//
//  MCSyncHost.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-11-08.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCObjectContextPool.h>
#import <MCClientServer/MCClientServerDefines.h>

@class MCSQLiteStore, MCPDataStore, MCAccessClient;
@class MCClientStage;
@class MCHostedServer, MCHostingNode;
@class MCEventTracker;


@interface MCSyncHost : NSOperation<MCObjectContextPoolClient> {

	MCEventTracker *eventTracker;
	MCPDataStore *serverStore;
	MCAccessClient *clientEndpoint;
	MCHostedServer *hostedServer;
	NSString *authenticatingUser;
	
	NSString *cloudID;
	
	NSString *databaseName;
	NSString *databaseHostname;
	NSString *databaseUsername;
	NSString *databasePassword;
	
	NSNumber *lockClassNumber;
	
	id userContext;
	
	MCSAuthorizationResultCode authResult;

	BOOL trustworthy;
	BOOL requiresAuth;
	BOOL waitingForAuth;
	BOOL executing;
	BOOL finished;
}

@property (nonatomic, retain) MCEventTracker *eventTracker;
@property (nonatomic, retain) MCPDataStore *serverStore;
@property (nonatomic, retain) MCAccessClient *clientEndpoint;
@property (nonatomic, retain) MCHostedServer *hostedServer;

@property (nonatomic, copy) NSString *authenticatingUser;

@property (nonatomic, copy) NSString *cloudID;
@property (nonatomic, copy) NSString *databaseName;
@property (nonatomic, copy) NSString *databaseHostname;
@property (nonatomic, copy) NSString *databaseUsername;
@property (nonatomic, copy) NSString *databasePassword;

@property (nonatomic, copy) NSNumber *lockClassNumber; // used by the stage for locking the replicant row

@property (nonatomic, retain) id userContext;

@property (nonatomic) MCSAuthorizationResultCode authResult;

@property (nonatomic) BOOL trustworthy;
@property (nonatomic) BOOL requiresAuth;
@property (readwrite) BOOL executing;
@property (readwrite) BOOL finished;

- (MCSyncHost *)initWithNode:(MCHostingNode *)node cloudAccount:(NSString *)aCloudID;
+ (MCSyncHost *)syncHostWithNode:(MCHostingNode *)node cloudAccount:(NSString *)aCloudID;

- (NSArray *)allStages;

- (BOOL)authenticateForStageUser:(MCClientStage *)stage;
- (BOOL)connectToServer;

- (void)generatePrimaryKeysForStage:(MCClientStage *)stage;
- (void)generatePrimaryKeysForStageFromStart:(MCClientStage *)stage;
- (void)generatePrimaryKeyForClient:(NSString *)clientID;

- (void)verifyOneStage:(MCClientStage *)stage;
- (void)syncOneStage:(MCClientStage *)stage;
- (void)syncAllStages;

@end
